#include <Wire.h>
#include <U8g2lib.h>

// OLED DRIVER: SH1106
U8G2_SH1106_128X64_NONAME_F_HW_I2C u8g2(U8G2_R0, /*reset=*/ U8X8_PIN_NONE);

const unsigned char titles [] PROGMEM = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0xe0, 
	0x07, 0x3c, 0x70, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x0f, 0x00, 0x00, 0xe0, 
	0x07, 0x38, 0x38, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0xe0, 
	0x07, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x80, 0x03, 0x00, 0xe0, 
	0x07, 0x38, 0x1c, 0x38, 0x1c, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x0e, 0x00, 0xe0, 
	0x07, 0x34, 0x1e, 0x76, 0x7e, 0x0e, 0x0f, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x18, 0x00, 0xe0, 
	0x07, 0x64, 0x1a, 0x33, 0x33, 0x86, 0x01, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0xe0, 
	0x07, 0x64, 0x19, 0x33, 0x33, 0xc6, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x60, 0x00, 0xe0, 
	0x07, 0xe4, 0x99, 0x31, 0x33, 0xc6, 0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0xc0, 0x00, 0xe0, 
	0x07, 0xe6, 0x98, 0x39, 0x1b, 0xc6, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x00, 0x80, 0x01, 0xe0, 
	0x07, 0xe2, 0x98, 0x39, 0x06, 0xc7, 0x00, 0x00, 0x00, 0x86, 0x01, 0x00, 0x00, 0x00, 0x03, 0xe0, 
	0x07, 0x63, 0x9c, 0x3b, 0x07, 0xc7, 0x07, 0x00, 0x00, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x06, 0xe0, 
	0x87, 0x07, 0x3e, 0x11, 0x1f, 0x83, 0x01, 0x00, 0x80, 0x61, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xe0, 
	0x07, 0x00, 0x00, 0x80, 0x31, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe0, 
	0x07, 0x00, 0x00, 0x80, 0x31, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x70, 0x00, 0x00, 0x20, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x0c, 0x00, 0xfe, 0x03, 0x00, 0x60, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x80, 0xff, 0x0f, 0x00, 0x60, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x06, 0xc0, 0xff, 0x1f, 0x00, 0x40, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x06, 0xe0, 0xcf, 0x3f, 0x00, 0xc0, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0xf0, 0x07, 0x7f, 0x00, 0xc0, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x03, 0xf0, 0x73, 0x7e, 0x00, 0xc0, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x03, 0xf8, 0xfb, 0xfe, 0x00, 0x80, 0xe0, 
	0x07, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x10, 0x03, 0xf8, 0xfb, 0xfe, 0x00, 0x80, 0xe0, 
	0x07, 0x00, 0x00, 0x98, 0x01, 0x00, 0x00, 0x00, 0x10, 0x03, 0xf8, 0x73, 0xfe, 0x00, 0x80, 0xe0, 
	0x07, 0x00, 0x00, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x10, 0x03, 0xf8, 0x07, 0xff, 0x00, 0x80, 0xe0, 
	0x07, 0x00, 0x00, 0x9c, 0x01, 0x00, 0x00, 0x00, 0x10, 0x01, 0xf8, 0x03, 0xfe, 0x00, 0x80, 0xe0, 
	0x07, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01, 0xf8, 0xf9, 0xfe, 0x00, 0x80, 0xe0, 
	0x07, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01, 0xf8, 0xf9, 0xfc, 0x00, 0x80, 0xe0, 
	0x07, 0x00, 0x00, 0xec, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01, 0xf8, 0xf9, 0xfc, 0x00, 0x80, 0xe0, 
	0x07, 0x00, 0x00, 0xcc, 0x01, 0x00, 0x00, 0x00, 0x10, 0x01, 0xf8, 0xf9, 0xfc, 0x00, 0xc0, 0xe0, 
	0x07, 0x00, 0x00, 0x86, 0x01, 0x00, 0x00, 0x00, 0x10, 0x01, 0xf0, 0x73, 0x7e, 0x00, 0xc0, 0xe0, 
	0x07, 0x00, 0x00, 0xce, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0xf0, 0x07, 0x7f, 0x00, 0xc0, 0xe0, 
	0x07, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0xe0, 0xff, 0x3f, 0x00, 0x40, 0xe0, 
	0x07, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0xc0, 0xff, 0x1f, 0x00, 0x40, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x80, 0xff, 0x0f, 0x00, 0x60, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x60, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x18, 0x03, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xe0, 
	0x07, 0x80, 0x3f, 0x00, 0x1c, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe0, 
	0x07, 0x00, 0x77, 0x00, 0x18, 0x03, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x06, 0xe0, 
	0x07, 0x00, 0x63, 0x00, 0x1c, 0x03, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0xe0, 
	0x07, 0x00, 0x63, 0x70, 0x8c, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x03, 0xe0, 
	0x07, 0x00, 0x73, 0xf8, 0x8c, 0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x80, 0x01, 0xe0, 
	0x07, 0x00, 0x3f, 0x44, 0x8c, 0x01, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0xe0, 0x00, 0xe0, 
	0x07, 0x80, 0x3f, 0x66, 0x8c, 0x01, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0, 
	0x07, 0x80, 0x71, 0x63, 0x86, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x18, 0x00, 0xe0, 
	0x07, 0x80, 0x61, 0x73, 0x86, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x0e, 0x00, 0xe0, 
	0x07, 0x80, 0x71, 0x73, 0xc6, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x80, 0x03, 0x00, 0xe0, 
	0x07, 0xc0, 0x31, 0x77, 0xce, 0x01, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xf0, 0x01, 0x00, 0xe0, 
	0x07, 0xe0, 0x1f, 0x26, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x1f, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x00, 0xe0, 
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


// Affirmative
const char* affirmative[] = {
  "It is certain","It is decidedly so","Without a doubt","Yes definitely",
  "You may rely on it","As I see it, yes","Most likely","Outlook good",
  "Yes","Signs point to yes"
};
// Non-Committal
const char* noncommittal[] = {
  "Reply hazy, try again","Ask again later","Better not tell you now",
  "Cannot predict now","Concentrate and ask again"
};
// Negative
const char* negative[] = {
  "Don't count on it","My reply is no","My sources say no",
  "Outlook not so good","Very doubtful"
};
void wrapText(const char* text, const uint8_t lineHeight) {
  int x = 0, y = lineHeight;
  char word[32];
  int idx = 0;

  for (int i = 0; text[i] != '\0'; i++) {
    if (text[i] == ' ' || text[i+1] == '\0') {
      // word complete
      if (text[i+1] == '\0') {
        word[idx++] = text[i];
      }
      word[idx] = '\0';

      int w = u8g2.getStrWidth(word);
      if (x + w > 128) { // wrap to new line
        x = 0;
        y += lineHeight;
      }
      u8g2.setCursor(x, y);
      u8g2.print(word);
      x += w + u8g2.getStrWidth(" "); // add space width
      idx = 0;
    } else {
      word[idx++] = text[i];
    }
  }
}

const char* messages[] = {
  "It is certain","It is decidedly so","Without a doubt","Yes definitely",
  "You may rely on it","As I see it, yes","Most likely","Outlook good",
  "Yes","Signs point to yes",
  "Reply hazy, try again","Ask again later","Better not tell you now",
  "Cannot predict now","Concentrate and ask again",
  "Don't count on it","My reply is no","My sources say no",
  "Outlook not so good","Very doubtful"
};
const int totalMessages = sizeof(messages) / sizeof(messages[0]);
void testAllMessages() {
  for (int i = 0; i < totalMessages; i++) {
    String fullMsg = String(i + 1) + ". " + messages[i]; // index + message
    u8g2.clearBuffer();
    u8g2.setFont(u8g2_font_10x20_tr); // big font
    wrapText(fullMsg.c_str(), 20);    // wrap with line height 20
    u8g2.sendBuffer();
    delay(2000);
  }
}


void setup() {
  u8g2.begin();
  randomSeed(micros());

  // Pick random message from all lists
  int total = 10 + 5 + 5;
  int pick = random(total);
  const char* msg;
  if (pick < 10) msg = affirmative[pick];
  else if (pick < 15) msg = noncommittal[pick - 10];
  else msg = negative[pick - 15];

  u8g2.clearBuffer();
  u8g2.drawXBMP(0, 0, 128, 64, titles);
  u8g2.sendBuffer();
  delay(2000);

  // Display message
  u8g2.clearBuffer();
  u8g2.setFont(u8g2_font_10x20_tr); // Large font (size 2 look)
  wrapText(msg, 20); // 20 = line height for 10x20 font
  u8g2.sendBuffer();

  
  
}

void loop() {}
